<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title>Register Now with Core Mining and Start Your Online Earning Journey</title>
    <meta name="description" content="Register with Core Mining today and begin your online earning journey! Core Mining is a gold mining company that mines gold and distributes the profits with its users.">

    <meta property="og:type" content="website">
    <meta property="og:site_name" content="Core Mining">
    <meta property="og:title" content="Register Now with Core Mining and Start Your Online Earning Journey">
    <meta property="og:description" content="Register with Core Mining today and begin your online earning journey! Core Mining is a gold mining company that mines gold and distributes the profits with its users.">
    <meta property="og:image" content="<?php echo e(asset('assets/dashboard/images/invite/invite.jpeg', request()->secure())); ?>">
    <meta property="og:image:secure_url" content="<?php echo e(asset('assets/dashboard/images/invite/invite.jpeg', true)); ?>">
    <meta property="og:url" content="<?php echo e(url()->full()); ?>">

    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Register Now with Core Mining and Start Your Online Earning Journey">
    <meta name="twitter:description" content="Register with Core Mining today and begin your online earning journey! Core Mining is a gold mining company that mines gold and distributes the profits with its users.">
    <meta name="twitter:image" content="<?php echo e(asset('assets/dashboard/images/invite/invite.jpeg', request()->secure())); ?>">

    <!-- Favicon -->
    <link rel="icon" type="image/jpeg" href="<?php echo e(asset('assets/dashboard/images/meta/logo-3.jpeg')); ?>">
    <!-- Apple Touch Icons for iOS -->
    <link rel="apple-touch-icon" sizes="180x180" href="<?php echo e(asset('assets/dashboard/images/meta/logo-3.jpeg')); ?>">
    <link rel="apple-touch-icon" sizes="152x152" href="<?php echo e(asset('assets/dashboard/images/meta/logo-3.jpeg')); ?>">
    <link rel="apple-touch-icon" sizes="144x144" href="<?php echo e(asset('assets/dashboard/images/meta/logo-3.jpeg')); ?>">
    <link rel="apple-touch-icon" sizes="120x120" href="<?php echo e(asset('assets/dashboard/images/meta/logo-3.jpeg')); ?>">
    <link rel="apple-touch-icon" sizes="114x114" href="<?php echo e(asset('assets/dashboard/images/meta/logo-3.jpeg')); ?>">
    <link rel="apple-touch-icon" sizes="76x76" href="<?php echo e(asset('assets/dashboard/images/meta/logo-3.jpeg')); ?>">
    <link rel="apple-touch-icon" sizes="72x72" href="<?php echo e(asset('assets/dashboard/images/meta/logo-3.jpeg')); ?>">
    <link rel="apple-touch-icon" sizes="60x60" href="<?php echo e(asset('assets/dashboard/images/meta/logo-3.jpeg')); ?>">
    <link rel="apple-touch-icon" sizes="57x57" href="<?php echo e(asset('assets/dashboard/images/meta/logo-3.jpeg')); ?>">
    <!-- Mobile Web App Meta Tags -->
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
    <meta name="apple-mobile-web-app-title" content="Core Mining ⛏️">
    <link rel="stylesheet" href="<?php echo e(asset('assets/dashboard/css/register.css')); ?>">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
</head>
<body>
    <div class="register-container">
        <!-- Background gradient overlay -->
        <div class="background-gradient"></div>

        <!-- Logo -->
        <div class="logo-container">
            <div class="logo">
                <img class="logo-icon" src="<?php echo e(asset('assets/dashboard/images/meta/logo-2.png')); ?>" alt="logo" style="object-fit: contain;">
                <span class="logo-text">Core Mining</span>
            </div>
        </div>


        <!-- Register Form Card -->
        <div class="register-card">
            <div class="card-content">
                <!-- Page Header (Centered) -->
                <div class="register-header" style="margin-bottom: 10px" >
                    <h1 class="welcome-title">Create an Account</h1>
                    <p class="welcome-subtitle">Join the future of AI investing</p>
                </div>

                <form id="registerForm" class="register-form" method="POST" action="<?php echo e(route('register')); ?>">
                    <?php echo csrf_field(); ?>
                    <!-- Error Messages (Frontend Only) -->
                    <div class="alert alert-error" id="registerError" style="display: none;">
                        <svg class="alert-icon" viewBox="0 0 20 20" fill="currentColor">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z" clip-rule="evenodd"/>
                        </svg>
                        <div class="alert-messages" id="registerErrorText"></div>
                    </div>

                    <!-- Success Messages (Frontend Only) -->
                    <div class="alert alert-success" id="registerSuccess" style="display: none;">
                        <svg class="alert-icon" viewBox="0 0 20 20" fill="currentColor">
                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                        </svg>
                        <span id="registerSuccessText"></span>
                    </div>

                    <!-- Full Name Field -->
                    <div class="form-group">
                        <label for="name" class="form-label">Full Name</label>
                        <div class="input-wrapper">
                            <svg class="input-icon" viewBox="0 0 20 20" fill="currentColor">
                                <path fill-rule="evenodd" d="M10 9a3 3 0 100-6 3 3 0 000 6zm-7 9a7 7 0 1114 0H3z" clip-rule="evenodd"/>
                            </svg>
                            <input
                                type="text"
                                id="name"
                                name="name"
                                class="form-input <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                placeholder="Enter your full name"
                                value="<?php echo e(old('name')); ?>"
                                required
                                autocomplete="name"
                                autofocus
                            >
                        </div>
                        <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger mt-1" style="font-size: 0.75rem; color: #ef4444 !important;"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <!-- Email Field -->
                    <div class="form-group">
                        <label for="email" class="form-label">Email</label>
                        <div class="input-wrapper">
                            <svg class="input-icon" viewBox="0 0 20 20" fill="currentColor">
                                <path d="M2.003 5.884L10 9.882l7.997-3.998A2 2 0 0016 4H4a2 2 0 00-1.997 1.884z"/>
                                <path d="M18 8.118l-8 4-8-4V14a2 2 0 002 2h12a2 2 0 002-2V8.118z"/>
                            </svg>
                            <input
                                type="email"
                                id="email"
                                name="email"
                                class="form-input <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                placeholder="Enter your email"
                                value="<?php echo e(old('email')); ?>"
                                required
                                autocomplete="email"
                            >
                        </div>
                        <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger mt-1" style="font-size: 0.75rem; color: #ef4444 !important;"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                     <!-- Phone Field -->
                     <div class="form-group">
                        <label for="phone" class="form-label">Phone</label>
                        <div class="input-wrapper">
                            <svg class="input-icon" viewBox="0 0 20 20" fill="currentColor">
                                <path d="M2 3a1 1 0 011-1h2.153a1 1 0 01.986.836l1.703 8.827a1 1 0 01-.54 1.06l-6.43 3.655a1 1 0 01-1.25-.518L.879 12.5a1 1 0 01.54-1.06l6.43-3.655a1 1 0 01.986.836L9.5 9.5V7a1 1 0 011-1h2a1 1 0 011 1v2.5l1.153.836a1 1 0 01.986-.836l6.43 3.655a1 1 0 01.54 1.06l-1.25 2.518a1 1 0 01-1.25.518l-6.43-3.655a1 1 0 01-.54-1.06l1.703-8.827A1 1 0 0115.153 2H17a1 1 0 011 1v14a1 1 0 01-1 1H3a1 1 0 01-1-1V3z"/>
                            </svg>
                            <input
                                type="tel"
                                id="phone"
                                name="phone"
                                class="form-input <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                placeholder="03001234567 or +92 300 1234567"
                                value="<?php echo e(old('phone')); ?>"
                                required
                                autocomplete="tel"
                            >
                        </div>
                        <?php $__errorArgs = ['phone'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger mt-1" style="font-size: 0.75rem; color: #ef4444 !important;"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <!-- Phone Field -->
                    
                    
                    <?php
                        $appliedReferral = old('referral_code', $referralCode ?? request()->query('ref'));
                    ?>

                    <div class="form-group">
                        <label for="referral_code" class="form-label">Referral Code <span class="text-danger">*</span></label>
                        <div class="input-wrapper">
                            <svg class="input-icon" viewBox="0 0 20 20" fill="currentColor">
                                <path d="M8 16.5a1.5 1.5 0 11-3 0 1.5 1.5 0 013 0zM15 16.5a1.5 1.5 0 11-3 0 1.5 1.5 0 013 0z"/>
                                <path d="M3 4a1 1 0 00-1 1v10a1 1 0 001 1h1.05a2.5 2.5 0 014.9 0H10a1 1 0 001-1V5a1 1 0 00-1-1H3zM14 7a1 1 0 00-1 1v6.05A2.5 2.5 0 0115.95 16H17a1 1 0 001-1v-5a1 1 0 00-.293-.707l-2-2A1 1 0 0015 7h-1z"/>
                            </svg>

                            <?php if(!empty($appliedReferral)): ?>
                                <input type="hidden" name="referral_code" value="<?php echo e($appliedReferral); ?>">
                                <input
                                    type="text"
                                    id="referral_code"
                                    class="form-input <?php $__errorArgs = ['referral_code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    value="<?php echo e($appliedReferral); ?>"
                                    disabled
                                >
                            <?php else: ?>
                                <input
                                    type="text"
                                    id="referral_code"
                                    name="referral_code"
                                    class="form-input <?php $__errorArgs = ['referral_code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    placeholder="Enter referral code"
                                    value="<?php echo e(old('referral_code')); ?>"
                                    required
                                >
                            <?php endif; ?>
                        </div>
                        <?php $__errorArgs = ['referral_code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger mt-1" style="font-size: 0.75rem; color: #ef4444 !important;"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>


                    <!-- Password Field -->
                    <div class="form-group">
                        <label for="password" class="form-label">Password</label>
                        <div class="input-wrapper">
                            <svg class="input-icon" viewBox="0 0 20 20" fill="currentColor">
                                <path fill-rule="evenodd" d="M5 9V7a5 5 0 0110 0v2a2 2 0 012 2v5a2 2 0 01-2 2H5a2 2 0 01-2-2v-5a2 2 0 012-2zm8-2v2H7V7a3 3 0 016 0z" clip-rule="evenodd"/>
                            </svg>
                            <input
                                type="password"
                                id="password"
                                name="password"
                                class="form-input <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                placeholder="Enter your password"
                                required
                                autocomplete="new-password"
                            >
                            <button type="button" class="password-toggle" id="passwordToggle" aria-label="Toggle password visibility">
                                <svg class="eye-icon" viewBox="0 0 20 20" fill="currentColor">
                                    <path d="M10 12a2 2 0 100-4 2 2 0 000 4z"/>
                                    <path fill-rule="evenodd" d="M.458 10C1.732 5.943 5.522 3 10 3s8.268 2.943 9.542 7c-1.274 4.057-5.064 7-9.542 7S1.732 14.057.458 10zM14 10a4 4 0 11-8 0 4 4 0 018 0z" clip-rule="evenodd"/>
                                </svg>
                            </button>
                        </div>
                        <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="text-danger mt-1" style="font-size: 0.75rem; color: #ef4444 !important;"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <!-- Confirm Password Field -->
                    

                    <!-- Terms and Conditions Checkbox -->
                    <div class="form-group">
                        <label class="checkbox-wrapper">
                            <input
                                type="checkbox"
                                name="terms"
                                id="terms"
                                class="checkbox-input"
                                required
                            >
                            <span class="checkbox-custom"></span>
                            <span class="checkbox-label">I accept the <a href="<?php echo e(route('terms')); ?>" class="terms-link">terms and conditions</a></span>
                        </label>
                    </div>

                    <!-- Sign Up Button -->
                    <button type="submit" class="signup-button" id="signupButton">
                        <span class="button-text">Sign Up</span>
                        <svg class="button-loader" viewBox="0 0 24 24" fill="none">
                            <circle cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4" stroke-opacity="0.25"/>
                            <path fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"/>
                        </svg>
                    </button>

                    <!-- Login Link -->
                    <div class="login-link">
                        <span class="login-text">Already have an account?</span>
                        <a href="<?php echo e(route('login')); ?>" class="login-link-text">Login</a>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script src="<?php echo e(asset('assets/dashboard/js/register.js')); ?>"></script>
</body>
</html>

<?php /**PATH C:\laragon\www\investment\resources\views/auth/register.blade.php ENDPATH**/ ?>