<?php if(isset($referralActivitiesData) && $referralActivitiesData['total'] > 0): ?>
    <div class="mining-activity-list">
        <?php $__currentLoopData = $referralActivitiesData['data']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $activity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php
                $date = \Carbon\Carbon::parse($activity['created_at']);
                $dateFormatted = $date->format('M d, Y');
                $timeFormatted = $date->format('g:i A');
                $dateTimeFormatted = $dateFormatted . ', ' . $timeFormatted;
                $amountFormatted = '+' . number_format($activity['amount'], 6, '.', '');
                $walletBalanceFormatted = number_format($activity['referral_wallet_balance'], 6, '.', '');
            ?>
            <div class="mining-activity-item" 
                 data-activity='<?php echo json_encode($activity, 15, 512) ?>'
                 style="cursor: pointer;">
                <div class="mining-activity-icon">
                    <i class="fas fa-check"></i>
                </div>
                <div class="mining-activity-content-wrapper">
                    <div class="mining-activity-type"><?php echo e($activity['type_label']); ?></div>
                    <div class="mining-activity-date"><?php echo e($dateTimeFormatted); ?></div>
                    <div class="mining-activity-status">completed</div>
                </div>
                <div class="mining-activity-amount-wrapper">
                    <div class="mining-activity-amount"><?php echo e($amountFormatted); ?></div>
                    <div class="mining-activity-wallet-balance">Referral Wallet: $<?php echo e($walletBalanceFormatted); ?></div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>

    <?php if($referralActivitiesData['last_page'] > 1): ?>
        <div class="mining-activity-pagination">
            <?php
                $currentPage = $referralActivitiesData['current_page'];
                $lastPage = $referralActivitiesData['last_page'];
            ?>
            
            <?php if($currentPage > 1): ?>
                <a href="#" data-page="<?php echo e($currentPage - 1); ?>" class="pagination-btn pagination-prev">
                    <i class="fas fa-chevron-left"></i>
                </a>
            <?php else: ?>
                <span class="pagination-btn pagination-prev disabled">
                    <i class="fas fa-chevron-left"></i>
                </span>
            <?php endif; ?>

            <?php
                $startPage = max(1, $currentPage - 2);
                $endPage = min($lastPage, $currentPage + 2);
                
                // Show first page if not in range
                if ($startPage > 1) {
                    $endPage = min($lastPage, $startPage + 4);
                }
                
                // Show last page if not in range
                if ($endPage < $lastPage) {
                    $startPage = max(1, $endPage - 4);
                }
            ?>

            <?php if($startPage > 1): ?>
                <a href="#" data-page="1" class="pagination-number">1</a>
                <?php if($startPage > 2): ?>
                    <span class="pagination-ellipsis">...</span>
                <?php endif; ?>
            <?php endif; ?>

            <?php for($page = $startPage; $page <= $endPage; $page++): ?>
                <?php if($page == $currentPage): ?>
                    <span class="pagination-number active"><?php echo e($page); ?></span>
                <?php else: ?>
                    <a href="#" data-page="<?php echo e($page); ?>" class="pagination-number"><?php echo e($page); ?></a>
                <?php endif; ?>
            <?php endfor; ?>

            <?php if($endPage < $lastPage): ?>
                <?php if($endPage < $lastPage - 1): ?>
                    <span class="pagination-ellipsis">...</span>
                <?php endif; ?>
                <a href="#" data-page="<?php echo e($lastPage); ?>" class="pagination-number"><?php echo e($lastPage); ?></a>
            <?php endif; ?>

            <?php if($currentPage < $lastPage): ?>
                <a href="#" data-page="<?php echo e($currentPage + 1); ?>" class="pagination-btn pagination-next">
                    <i class="fas fa-chevron-right"></i>
                </a>
            <?php else: ?>
                <span class="pagination-btn pagination-next disabled">
                    <i class="fas fa-chevron-right"></i>
                </span>
            <?php endif; ?>
        </div>
    <?php endif; ?>
<?php else: ?>
    <div class="mining-empty-state">
        <div class="mining-empty-icon">
            <i class="fas fa-chart-area"></i>
        </div>
        <p class="mining-empty-text">No referral activity yet. Invite users to earn commissions.</p>
    </div>
<?php endif; ?>

<?php /**PATH C:\laragon\www\investment\resources\views/dashboard/partials/referral-activities.blade.php ENDPATH**/ ?>